/*****************************************
* Klasse TcpProtocol
*
* Beschreibung: Stellt die Schnittstellen zu den Anwendungen zur Verfuegung
* Application calls
* Autor: Pascal ILBOUDO modifiziert durch Gunter Weiss
*****************************************/
import java.util.Vector;
import java.util.Date;


public class TcpProtocol {


  protected  HostNetBuffer tonetbuffer;
  protected  HostNetBuffer fromnetbuffer ;
  protected  Vector tcbbuffer = new Vector(30);
  public   Vector history = new Vector(3000);
  public   RightToSend darfsenden = new RightToSend();
  protected  SegArrive seg_arrive;
  private  BuildTcpSegment buildseg = new BuildTcpSegment();
  protected SessionControlBlock scbtcp;
  private TcpSegment alive_segm;
  public KeepaliveTimer k_timer;




int send;
int open;
byte[] receive;
int close;
int abort;
int stat = -1;
final static int max_cid = 2;
public int       cid = 0;
protected int ncid = 0; // privat protected
/*private*/ protected static long time ;
TcpStarter outerparent;
Host host;
protected int my_host;

static { time = new Date().getTime();}



public TcpProtocol (Host parent,TcpStarter home,HostNetBuffer tonvect,HostNetBuffer fronvect, int mytcp){
      this .host = parent;
      this .outerparent = home;
      this .tonetbuffer = tonvect;
      this .fromnetbuffer = fronvect;
      this .my_host = mytcp;
      k_timer = new KeepaliveTimer( this );
      seg_arrive = new SegArrive(this,outerparent.halt,tcbbuffer,tonetbuffer,fromnetbuffer,time);
}

/*****************************************
* Methode Clear
*
* Beschreibung: Loescht den History Puffer
* Parameter: kein
* Rueckgabewert: kein
* Autor: Gunter Weiss
*****************************************/
public final synchronized void Clear(){
    history.removeAllElements();
    }

/*****************************************
* Methode sendAliveSegment()
*
* Beschreibung:Schicken eines Segmentes, um zu sehen ob Verbindung noch besteht und zur Synchronisation.
* Parameter: int Anwendung ID, byte[] zuschickenden Daten, byte Push bit, byte Urgent bit
* Rueckgabewert:int 0 = OK, -1 = nicht OK
* Autor: Gunter Weiss
*****************************************/
  public void sendAliveSegment(SessionControlBlock scbtcp){
     alive_segm = new TcpSegment();
     alive_segm.Lpnumb = scbtcp.Lpnumb;
     alive_segm.Dpnumb = scbtcp.Dpnumb;
     alive_segm.ACK = 1;
     alive_segm.Acknumb = scbtcp.RCVNXT;
     alive_segm.Seqnumb = scbtcp.SNDUNA;
     alive_segm = new Checksum().build(alive_segm);
     history. addElement(new BuildHTcpSegment().BuildHTcpSegment(alive_segm,true,new Date().getTime(),true,"ESTABLISHED"));
     tonetbuffer.putElement(alive_segm);
     k_timer.start(scbtcp);
  }
/*****************************************
* Methode Send
*
* Beschreibung:Schicken von Daten
* Parameter: int Anwendung ID, byte[] zuschickenden Daten, byte Push bit, byte Urgent bit
* Rueckgabewert:int 0 = OK, -1 = nicht OK
* Autor: Gunter Weiss
*****************************************/

public final synchronized int Send(int xyid, byte[] data, byte PUSH, byte URGENT){

    send = new Send().Send(this, xyid, data, PUSH, URGENT);
    return send;
}

/*****************************************
* Methode Open
*
* Beschreibung: Verbindung eroeffnen
* Parameter: short local port, short destination port, int passive oder active
* Rueckgabewert: int 0=OK, -1 = nicht OK (erfolgreich)
* Autor: Gunter Weiss
*****************************************/

public final synchronized int Open(short Lport, short Dport, int stat){
    this .stat = stat;
    open = new Open().Open(this, Lport, Dport, stat);
    return open;
}

/*****************************************
* Methode Receive
*
* Beschreibung: Empfangen von Daten
* Parameter: int connectionID, int die Anzahl der Daten die empfangen werden knnen
* Rueckgabewert: byte[] Array mit den Daten wobei, das erste byte den push bit kennzeichnet, das zweite den urgent bit, ab den dritten die Daten
* Autor: Gunter Weiss
*****************************************/

public final synchronized byte[] Receive(int contid, int anzahl){

    receive = new Receive().Receive(this, contid, anzahl);
    return receive;
}
/*****************************************
* Methode Close
*
* Beschreibung: Schliesst eine Verbindung
* Parameter: int dein ID
* Rueckgabewert: int 0 = erfolgreich, -1 = nicht erfolgreich
* Autor: Gunter Weiss
*****************************************/

public final synchronized int Close(int x){

    close = new Close().Close( this, x );
    return close;
}

/*****************************************
* Methode Abort
*
* Beschreibung: Abruptes Schliessen einer Verbindung
* Parameter: int application ID (dein ID)
* Rueckgabewert: int 0 = OK, -1 nicht OK
* Autor: Gunter Weiss
*****************************************/

public final synchronized int Abort(int y){

       abort = new Abort().Abort( this, y);
       return abort;
}

/*****************************************
* Methode ConStatus
*
* Beschreibung: Liefert den Status der Verbindung zurueck
* Parameter: int dein ID
* Rueckgabewert: zeiger auf den SessionControlBlock
* Autor: Gunter Weiss
*****************************************/

public final /*synchronized*/ SessionControlBlock ConStatus(int z){
         int vorhanden;
            vorhanden = new Suche().conid(z,tcbbuffer);
         if (vorhanden != -1)
            return ((SessionControlBlock)tcbbuffer.elementAt(vorhanden));
         else return (new SessionControlBlock());
         }

/*****************************************
* Methode getrecqueue
*
* Beschreibung: Liefert die daten, die angefordert werden, wird von Receive gerufen .
* Parameter: Puffer, anzahl der daten
* Rueckgabewert:byte[] Array mit den Daten
* Autor: Pascal ILBOUDO
*****************************************/

public final synchronized byte[] getrecqueue(Puffer puf, int anzahl) {

  if(puf.size()==0)
   {
    byte[] resp = {0,0,-6};
    return resp; // keine Daten
   }
  else
   {
     if(puf.size() > anzahl) // Mehr daten im Puffer als angefordert
     {
     // System.out.println(" Getrecq Fall pufsize > anzahl)");
	  byte[] resp = new byte[anzahl+2];
      for (int j=2; j < anzahl+2; j++){resp[j] = puf.elementAt(j-2);}
      resp[0] = 0;
      resp[1] = 0;
      for (int i = 0; i < anzahl; i++){ puf.removeElementAt(0);}
      return resp;
     }
    else
     {
      //System.out.println(" Getrecq Fall pufsize < anzahl)");
      byte[] resp = new byte[puf.size()+2];
      for (int j=2; j < puf.size()+2; j++){resp[j] = puf.elementAt(j-2);}
      resp[0] = 0; resp[1]=0;
      puf. removeAllElements();
      return resp; // weniger daten im Puffer als angefordert, du bekommst alles was da ist.
     }
   }
}

/*****************************************
* Methode getAllrecqueue
*
* Beschreibung: Wenn man receive im Close_Wait_State macht werden alle Daten die im Puffer sind geschickt, egal wieviel, da die Verbindung
* bald geschlossen wird, wird von Receive gerufen (intern)
* Parameter: Puffer, Anzahl
* Rueckgabewert: byte[] Array von bytes
* Autor: Pascal ILBOUDO
*****************************************/
public final synchronized byte[] getAllrecqueue(Puffer puf,int anzahl){
      byte[] resp = new byte[puf.size()+2];
      for (int j=2; j < puf.size()+2; j++){resp[j] = puf.elementAt(j-2);}
      resp[0] = 1;
      resp[1] = 0;
      puf. removeAllElements();
      return resp;
}
/*****************************************
* Methode getStopped
*
* Beschreibung: Stop Threads of ThreadGroup halt
* Parameter:
* Rueckgabewert:
* Autor: Gunter Weiss
*****************************************/

public void getStopped() {
   seg_arrive .suspend();
}
/*****************************************
* Methode getStat()
* Beschreibung: returns Integer that spezifies Client or Server
* Parameter: -
* Rueckgabewert:Integer
* Autor: Gunter Weiss
*****************************************/

public int getStat() {
   return stat;
}

}
